// 定义选择器
const selectors = {
  deleteButton: 'button.relative.col-start-2.flex.max-w-\\[200px\\].justify-center.rounded-md.bg-gray-800.px-4.py-2.text-sm.font-bold.text-red',
  confirmInput: 'input[placeholder="Type DELETE MY ACCOUNT to confirm"]',
  confirmButton: 'button.relative.col-start-2.flex.justify-center.rounded-md.bg-gray-800.px-4.py-2.text-sm.font-bold.text-red-700',
  googleButton: 'button.group.relative.flex.w-full.items-center.justify-center.rounded-md.border.border-form-border-secondary.bg-form-border.px-4.py-2.text-sm.font-semibold.text-white'
};

let currentTab = null;
let autoExecuting = false;

// 检查当前标签页是否是 Windsurf 设置页面
async function checkCurrentTab() {
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  if (tab && tab.url && tab.url.includes('windsurf.com/settings')) {
    currentTab = tab;
    // 如果已经在设置页面，启用所有按钮
    enableAllButtons();
    document.getElementById('status').textContent = '已在设置页面，可以开始操作';
    return true;
  }
  return false;
}

// 启用所有按钮
function enableAllButtons() {
  document.getElementById('clickDeleteButton').disabled = false;
  document.getElementById('fillConfirmText').disabled = false;
  document.getElementById('clickConfirmButton').disabled = false;
  document.getElementById('clickGoogleButton').disabled = false;
}

// 页面加载时检查当前标签页
document.addEventListener('DOMContentLoaded', async () => {
  await checkCurrentTab();
  // 添加自动执行按钮的事件监听器
  document.getElementById('autoExecute').addEventListener('click', autoExecuteProcess);
});

// 自动执行流程
async function autoExecuteProcess() {
  const statusDiv = document.getElementById('status');
  autoExecuting = true;
  
  try {
    // 1. 打开设置页面（如果还没有打开）
    if (!currentTab || !currentTab.url || !currentTab.url.includes('windsurf.com/settings')) {
      statusDiv.textContent = '正在打开设置页面...';
      await openSettingsPage();
    }
    
    // 等待页面加载
    await new Promise(resolve => setTimeout(resolve, 3000));
    
    // 2. 点击删除账号按钮
    statusDiv.textContent = '正在点击删除账号按钮...';
    await executeStep('clickDeleteButton', selectors.deleteButton);
    
    // 等待弹窗出现
    await new Promise(resolve => setTimeout(resolve, 1000));
    
    // 3. 输入确认文本
    statusDiv.textContent = '正在输入确认文本...';
    await executeStep('fillConfirmText', selectors.confirmInput);
    
    // 4. 点击确认删除按钮
    statusDiv.textContent = '正在点击确认删除按钮...';
    await executeStep('clickConfirmButton', selectors.confirmButton);
    
    // 等待页面跳转
    await new Promise(resolve => setTimeout(resolve, 2000));
    
    // 5. 跳转到登录页面并点击 Google 登录按钮
    statusDiv.textContent = '正在跳转到登录页面...';
    currentTab = await chrome.tabs.update(currentTab.id, {
      url: 'https://windsurf.com/account/login'
    });
    
    // 等待登录页面加载
    await new Promise(resolve => setTimeout(resolve, 2000));
    
    // 点击 Google 登录按钮
    await executeStep('clickGoogleButton', selectors.googleButton);
    
    statusDiv.textContent = '自动执行完成！如果有任何步骤失败，可以使用手动按钮重试。';
  } catch (error) {
    statusDiv.textContent = '自动执行出错: ' + error.message + '。您可以使用手动按钮继续操作。';
    console.error('自动执行错误:', error);
  } finally {
    autoExecuting = false;
    enableAllButtons();
  }
}

// 执行单个步骤
async function executeStep(buttonId, selector) {
  try {
    await chrome.scripting.executeScript({
      target: { tabId: currentTab.id },
      func: buttonId === 'fillConfirmText' ? fillInput : clickElement,
      args: buttonId === 'fillConfirmText' ? [selector, 'DELETE MY ACCOUNT'] : [selector]
    });
  } catch (error) {
    throw new Error(`${buttonId} 执行失败: ${error.message}`);
  }
}

// 打开设置页面
async function openSettingsPage() {
  // 检查是否已经打开了设置页面
  const [existingTab] = await chrome.tabs.query({ 
    url: ['https://windsurf.com/settings*']
  });
  
  if (existingTab) {
    currentTab = existingTab;
    await chrome.tabs.update(existingTab.id, { active: true });
  } else {
    currentTab = await chrome.tabs.create({
      url: 'https://windsurf.com/settings'
    });
  }
  return currentTab;
}

// 打开设置页面按钮事件
document.getElementById('openSettings').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  statusDiv.textContent = '正在打开设置页面...';
  
  try {
    await openSettingsPage();
    await new Promise(resolve => setTimeout(resolve, 3000));
    enableAllButtons();
    statusDiv.textContent = '设置页面已打开，可以开始操作';
  } catch (error) {
    statusDiv.textContent = '发生错误: ' + error.message;
  }
});

// 点击删除账号按钮
document.getElementById('clickDeleteButton').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  try {
    if (!currentTab) await checkCurrentTab();
    await executeStep('clickDeleteButton', selectors.deleteButton);
    statusDiv.textContent = '已点击删除账号按钮';
  } catch (error) {
    statusDiv.textContent = '错误: ' + error.message;
  }
});

// 输入确认文本
document.getElementById('fillConfirmText').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  try {
    if (!currentTab) await checkCurrentTab();
    await executeStep('fillConfirmText', selectors.confirmInput);
    statusDiv.textContent = '已输入确认文本';
  } catch (error) {
    statusDiv.textContent = '错误: ' + error.message;
  }
});

// 点击确认删除按钮
document.getElementById('clickConfirmButton').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  try {
    if (!currentTab) await checkCurrentTab();
    await executeStep('clickConfirmButton', selectors.confirmButton);
    statusDiv.textContent = '已点击确认删除按钮';
  } catch (error) {
    statusDiv.textContent = '错误: ' + error.message;
  }
});

// 点击 Google 登录按钮
document.getElementById('clickGoogleButton').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  try {
    // 确保我们在登录页面
    currentTab = await chrome.tabs.update(currentTab.id, {
      url: 'https://windsurf.com/account/login'
    });
    await new Promise(resolve => setTimeout(resolve, 2000));
    
    await executeStep('clickGoogleButton', selectors.googleButton);
    statusDiv.textContent = '已点击 Google 登录按钮';
  } catch (error) {
    statusDiv.textContent = '错误: ' + error.message;
  }
});

// 辅助函数：点击元素
function clickElement(selector) {
  const element = document.querySelector(selector);
  if (!element) {
    throw new Error(`找不到元素: ${selector}`);
  }
  element.click();
}

// 辅助函数：填充输入框
function fillInput(selector, text) {
  const element = document.querySelector(selector);
  if (!element) {
    throw new Error(`找不到元素: ${selector}`);
  }
  element.value = text;
  element.dispatchEvent(new Event('input', { bubbles: true }));
  element.dispatchEvent(new Event('change', { bubbles: true }));
} 